/*
 * Decompiled with CFR 0.152.
 */
package com.renyigesai.immortalers_delight.item.food;

import com.renyigesai.immortalers_delight.init.ImmortalersDelightItems;
import com.renyigesai.immortalers_delight.item.food.EdibleBlockFoodItem;
import com.renyigesai.immortalers_delight.potion.immortaleffects.FreezeEffect;
import com.renyigesai.immortalers_delight.util.DifficultyModeUtil;
import com.renyigesai.immortalers_delight.util.datautil.EffectData;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import vectorwing.farmersdelight.common.Configuration;

public class FrostyCrownMousseItem
extends EdibleBlockFoodItem {
    public static final String EAT_THIS = "immortalers_delight_frosty_crown_mousse_eater";

    public FrostyCrownMousseItem(Block pBlock, Item.Properties pProperties, FoodProperties poweredFoodProperties, boolean hasCustomTooltip) {
        super(pBlock, pProperties, poweredFoodProperties, hasCustomTooltip);
    }

    public FrostyCrownMousseItem(Block pBlock, Item.Properties pProperties) {
        super(pBlock, pProperties);
    }

    @Override
    protected void addAheadFoodEffect(ItemStack stack, Level level, LivingEntity livingEntity) {
        livingEntity.m_146924_(true);
        if (!level.m_5776_()) {
            livingEntity.m_146868_(false);
        }
    }

    public void m_5551_(ItemStack stack, Level level, LivingEntity consumer, int timeLeft) {
        if (!level.m_5776_() && DifficultyModeUtil.isPowerBattleMode() && timeLeft + 1 <= this.m_8105_(stack) / 2) {
            this.m_5922_(stack, level, consumer);
        }
        super.m_5551_(stack, level, consumer, timeLeft);
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag isAdvanced) {
        if (((Boolean)Configuration.FOOD_EFFECT_TOOLTIP.get()).booleanValue()) {
            MutableComponent textValue = Component.m_237115_((String)"tooltip.immortalers_delight.frosty_crown_mousse");
            tooltip.add((Component)textValue.m_130940_(ChatFormatting.RED));
        }
        super.m_7373_(stack, level, tooltip, isAdvanced);
    }

    public void m_5929_(Level pLevel, LivingEntity livingEntity, ItemStack pStack, int pRemainingUseDuration) {
        if (this.m_8105_(pStack) - pRemainingUseDuration > 32) {
            this.addAheadFoodEffect(pStack, livingEntity.m_9236_(), livingEntity);
        }
        if (pRemainingUseDuration == 1) {
            this.addEatEffect(pStack, pLevel, livingEntity);
            if (!livingEntity.m_6084_() || livingEntity.m_6095_().m_204039_(EntityTypeTags.f_144294_) || livingEntity.m_9236_().m_5776_()) {
                return;
            }
            boolean isPowerful = DifficultyModeUtil.isPowerBattleMode();
            if (pStack.m_150930_((Item)ImmortalersDelightItems.FROSTY_CROWN_MOUSSE.get())) {
                FreezeEffect.applyImmortalEffect(livingEntity, isPowerful ? 3600 : 1200, 2);
                if (livingEntity instanceof Player) {
                    Player player = (Player)livingEntity;
                    CompoundTag tag = player.getPersistentData();
                    tag.m_128405_(EAT_THIS, isPowerful ? 3600 : 1200);
                }
            }
        }
    }

    @Mod.EventBusSubscriber(modid="immortalers_delight", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class FrostyCrownMousseEvents {
        @SubscribeEvent
        public static void eatPeiCooldown(LivingEvent.LivingTickEvent event) {
            CompoundTag tag;
            LivingEntity entity = event.getEntity();
            if (entity.m_6084_() && entity.f_19797_ % 5 == 0 && !entity.m_6095_().m_204039_(EntityTypeTags.f_144294_) && !entity.m_9236_().m_5776_() && (tag = entity.getPersistentData()).m_128425_(FrostyCrownMousseItem.EAT_THIS, 3) && tag.m_128451_(FrostyCrownMousseItem.EAT_THIS) > 0) {
                HashMap<UUID, EffectData> freezedEntitys = new HashMap<UUID, EffectData>(FreezeEffect.getEntityMap());
                if (!freezedEntitys.containsKey(entity.m_20148_())) {
                    FreezeEffect.applyImmortalEffect(entity, tag.m_128451_(FrostyCrownMousseItem.EAT_THIS), 2);
                }
                if (tag.m_128451_(FrostyCrownMousseItem.EAT_THIS) - 5 <= 0) {
                    tag.m_128473_(FrostyCrownMousseItem.EAT_THIS);
                } else {
                    tag.m_128405_(FrostyCrownMousseItem.EAT_THIS, tag.m_128451_(FrostyCrownMousseItem.EAT_THIS) - 5);
                }
            }
        }

        @SubscribeEvent
        public static void removeOnDeath(LivingDeathEvent event) {
            LivingEntity entity = event.getEntity();
            CompoundTag tag = entity.getPersistentData();
            if (tag.m_128425_(FrostyCrownMousseItem.EAT_THIS, 3) && tag.m_128451_(FrostyCrownMousseItem.EAT_THIS) > 0) {
                tag.m_128473_(FrostyCrownMousseItem.EAT_THIS);
                FreezeEffect.removeImmortalEffect(entity);
            }
        }
    }
}

